/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import com.silverminer.shrines.commands.LocateInBiomeChunkGenerator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import org.jetbrains.annotations.NotNull;

public class LocateInBiomeCommand {
    private static final DynamicCommandExceptionType ERROR_FAILED = new DynamicCommandExceptionType(args -> new TranslatableComponent("commands.locate.failed", new Object[]{args}));
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(args -> new TranslatableComponent("commands.locate.invalid", new Object[]{args}));

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"locateshrines").requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82127_((String)"inbiome").then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122882_)).then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122885_)).executes(commandContext -> LocateInBiomeCommand.locateInBiome((CommandSourceStack)commandContext.getSource(), ResourceOrTagLocationArgument.m_210970_((CommandContext)commandContext, (String)"structure"), (ResourceOrTagLocationArgument.Result<Biome>)ResourceOrTagLocationArgument.m_210952_((CommandContext)commandContext, (String)"biome"))))))).then(Commands.m_82127_((String)"new").then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122882_)).executes(commandContext -> LocateInBiomeCommand.locateNew((CommandSourceStack)commandContext.getSource(), ResourceOrTagLocationArgument.m_210970_((CommandContext)commandContext, (String)"structure"))))));
    }

    private static int locateNew(@NotNull CommandSourceStack commandSourceStack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ResourceOrTagLocationArgument.Result<ConfiguredStructureFeature<?, ?>> structureFeatureResult) throws CommandSyntaxException {
        Registry registry = commandSourceStack.m_81372_().m_5962_().m_175515_(Registry.f_122882_);
        HolderSet holderset = (HolderSet)((Optional)structureFeatureResult.m_207418_().map(resourceKey -> registry.m_203636_(resourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> ((Registry)registry).m_203431_(arg_0))).orElseThrow(() -> ERROR_INVALID.create((Object)structureFeatureResult.m_207276_()));
        BlockPos blockpos = new BlockPos(commandSourceStack.m_81371_());
        ServerLevel serverlevel = commandSourceStack.m_81372_();
        Pair pair = serverlevel.m_7726_().m_8481_().m_207970_(serverlevel, holderset, blockpos, 100, true);
        if (pair == null) {
            throw ERROR_FAILED.create((Object)structureFeatureResult.m_207276_());
        }
        return LocateInBiomeCommand.showLocateResult(commandSourceStack, structureFeatureResult, blockpos, pair, "commands.locate.success");
    }

    private static int locateInBiome(@NotNull CommandSourceStack commandSourceStack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ResourceOrTagLocationArgument.Result<ConfiguredStructureFeature<?, ?>> structureFeatureResult, ResourceOrTagLocationArgument.Result<Biome> biomeResult) throws CommandSyntaxException {
        Registry registry = commandSourceStack.m_81372_().m_5962_().m_175515_(Registry.f_122882_);
        HolderSet holderset = (HolderSet)((Optional)structureFeatureResult.m_207418_().map(resourceKey -> registry.m_203636_(resourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> ((Registry)registry).m_203431_(arg_0))).orElseThrow(() -> ERROR_INVALID.create((Object)structureFeatureResult.m_207276_()));
        BlockPos blockpos = new BlockPos(commandSourceStack.m_81371_());
        ServerLevel serverlevel = commandSourceStack.m_81372_();
        Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> pair = ((LocateInBiomeChunkGenerator)serverlevel.m_7726_().m_8481_()).findNearestMapFeature(serverlevel, (HolderSet<ConfiguredStructureFeature<?, ?>>)holderset, blockpos, 100, false, (Predicate<Holder<Biome>>)biomeResult);
        if (pair == null) {
            throw ERROR_FAILED.create((Object)structureFeatureResult.m_207276_());
        }
        return LocateInBiomeCommand.showLocateResult(commandSourceStack, structureFeatureResult, blockpos, pair, "commands.locate.success");
    }

    private static int showLocateResult(@NotNull CommandSourceStack commandSourceStack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ResourceOrTagLocationArgument.Result<?> structureResult, @NotNull BlockPos blockPos, @NotNull Pair<BlockPos, ? extends Holder<?>> foundStructure, String message) {
        BlockPos blockpos = (BlockPos)foundStructure.getFirst();
        String s = (String)structureResult.m_207418_().map(p_207538_ -> p_207538_.m_135782_().toString(), p_207511_ -> "#" + p_207511_.f_203868_() + " (" + ((Holder)foundStructure.getSecond()).m_203543_().map(p_207536_ -> p_207536_.m_135782_().toString()).orElse("[unregistered]") + ")");
        int i = Mth.m_14143_((float)LocateInBiomeCommand.dist(blockPos.m_123341_(), blockPos.m_123343_(), blockpos.m_123341_(), blockpos.m_123343_()));
        MutableComponent component = ComponentUtils.m_130748_((Component)new TranslatableComponent("chat.coordinates", new Object[]{blockpos.m_123341_(), "~", blockpos.m_123343_()})).m_130938_(p_207527_ -> p_207527_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + blockpos.m_123341_() + " ~ " + blockpos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"))));
        commandSourceStack.m_81354_((Component)new TranslatableComponent(message, new Object[]{s, component, i}), false);
        return i;
    }

    private static float dist(int pX1, int pZ1, int pX2, int pZ2) {
        int i = pX2 - pX1;
        int j = pZ2 - pZ1;
        return Mth.m_14116_((float)(i * i + j * j));
    }
}

